// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __MATRIX_MISC_H
#define __MATRIX_MISC_H

#include "Matrix4x4.h"

namespace dingus {

inline void matrixToDoubleTransposed34( const SMatrix4x4& m, double* mm ) {
	mm[0] = m._11; mm[4] = m._12; mm[8] = m._13;
	mm[1] = m._21; mm[5] = m._22; mm[9] = m._23;
	mm[2] = m._31; mm[6] = m._32; mm[10] = m._33;
	mm[3] = 0; mm[7] = 0; mm[11] = 0;
}

inline void matrixFromDoubleTransposed34( SMatrix4x4& m, const double* mm ) {
	m._11 = (float)mm[0]; m._12 = (float)mm[4]; m._13 = (float)mm[8];
	m._21 = (float)mm[1]; m._22 = (float)mm[5]; m._23 = (float)mm[9];
	m._31 = (float)mm[2]; m._32 = (float)mm[6]; m._33 = (float)mm[10];
}

};


#endif
