// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "PhysicsContext.h"

using namespace dingus;

CPhysicsContext::CPhysicsContext()
:	mContacts(0)
{
	mID = dWorldCreate();
	dWorldSetAutoEnableDepth( mID, 3 );
}

void CPhysicsContext::perform( float stepsize, int iterations )
{
	TMergeContactsMap::const_iterator it, itEnd = mMergeContacts.end();
	for( it = mMergeContacts.begin(); it != mMergeContacts.end(); ++it ) {
		dJointID cj = dJointCreateContact( mID, mContactJoints, &it->second );
		dJointAttach( cj, it->first, NULL );
	}
	mMergeContacts.clear();

	if( iterations > 0 )
		dWorldStepFast( mID, stepsize, iterations );
	else
		dWorldStep( mID, stepsize );
	mContactJoints.clear();
	mContacts = 0;
}

void CPhysicsContext::addMergeableContactJoint( const dContact& c, TPhysicsableID body1 )
{
	std::pair<TMergeContactsMap::iterator,bool> res = mMergeContacts.insert( std::make_pair(body1,c) );
	if( res.second ) {
		++mContacts;
		return;
	}
	// else merge contact with prev
	// kind of HACK way to do this
	dContact& cc = res.first->second;
	dVector3 norms;
	norms[0] = cc.geom.normal[0] + c.geom.normal[0];
	norms[1] = cc.geom.normal[1] + c.geom.normal[1];
	norms[2] = cc.geom.normal[2] + c.geom.normal[2];
	dReal lenSq = dDOT(norms,norms);
	const double LIMIT_UP = 0.3;
	if( lenSq < LIMIT_UP*LIMIT_UP ) {
		cc.geom.normal[0] = 0;
		cc.geom.normal[1] = 1;
		cc.geom.normal[2] = 0;
		cc.geom.depth = 0;
	} else if( c.geom.normal[1] > cc.geom.normal[1] ) {
		memcpy( &cc, &c, sizeof(cc) );
	}
}
