// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __PHYSICS_ODE_CTX_H
#define __PHYSICS_ODE_CTX_H


#include <ode/ode.h>
#include "../math/Vector3.h"
#include "PhysicsIDs.h"
#include "PhysicsJointGroup.h"

namespace dingus {



// --------------------------------------------------------------------------

class CPhysicsContext : public boost::noncopyable {
public:
	typedef dWorldID	TWorldID;
public:
	CPhysicsContext();
	~CPhysicsContext() { dWorldDestroy (mID); } // no virtual intentionally
	
	TWorldID	getID() const { return mID; }
	operator TWorldID() const { return mID; }
	
	void	setGravity( const SVector3& g ) { dWorldSetGravity(mID,g.x,g.y,g.z); }
	void	getGravity( SVector3& g ) const { dVector3 gg; dWorldGetGravity(mID,gg); g.x=(float)gg[0]; g.y=(float)gg[1]; g.z=(float)gg[2]; }
	
	void	setERP( float erp ) { dWorldSetERP(mID, erp); }
	float	getERP() const { return (float)dWorldGetERP(mID); }
	
	void	setCFM( float cfm ) { dWorldSetCFM(mID, cfm); }
	float	getCFM() const { return (float)dWorldGetCFM(mID); }
	
	void	perform( float stepsize, int iterations );

	void	addContactJoint( const dContact& c, TPhysicsableID body1, TPhysicsableID body2 );
	void	addMergeableContactJoint( const dContact& c, TPhysicsableID body1 );
	int		getContactCount() const { return mContacts; }
	
	void	impulseToForce( float stepsize, const SVector3& imp, SVector3& force )
	{ dVector3 f; dWorldImpulseToForce(mID,stepsize,imp.x,imp.y,imp.z,f); force.x=(float)f[0];force.y=(float)f[1];force.z=(float)f[2]; }

private:
	typedef std::map<TPhysicsableID,dContact>	TMergeContactsMap;
private:
	TWorldID			mID;
	CPhysicsJointGroup	mContactJoints;
	int					mContacts;

	TMergeContactsMap	mMergeContacts;
};


inline void CPhysicsContext::addContactJoint( const dContact& c, TPhysicsableID body1, TPhysicsableID body2 )
{
	dJointID cj = dJointCreateContact( mID, mContactJoints, &c );
	dJointAttach( cj, body1, body2 );
	++mContacts;
}



}; // namespace

#endif
