// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __PHYSICS_ODE_JOINT_GROUP_H
#define __PHYSICS_ODE_JOINT_GROUP_H

#include "PhysicsIDs.h"

namespace dingus {



// --------------------------------------------------------------------------

class CPhysicsJointGroup : public boost::noncopyable {
public:
	CPhysicsJointGroup() { mID = dJointGroupCreate(0); }
	~CPhysicsJointGroup() { dJointGroupDestroy(mID); }
	
	void create() {
		if(mID) dJointGroupDestroy (mID);
		mID = dJointGroupCreate(0);
	}
	
	TPhysicsJointGroupID getID() const { return mID; }
	operator TPhysicsJointGroupID() const { return mID; }
	
	void clear() { dJointGroupEmpty(mID); }

private:
	TPhysicsJointGroupID mID;
private:
	// no copy
	CPhysicsJointGroup (const CPhysicsJointGroup &);
	void operator= (const CPhysicsJointGroup &);
};


}; // namespace

#endif
