// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __PHYSICS_STAGE_H
#define __PHYSICS_STAGE_H

#include "../pipeline/PipelineStage.h"

namespace dingus {

class CPhysicsContext;


class CPhysicsStage : public IPipelineStage {
public:
	/**
	 *  @param stepSize Step size for physics integrator.
	 *  @param iterations Number of iterations to take. If less than one,
	 *		then non-iterative solver is used.
	 */
	explicit CPhysicsStage( CPhysicsContext& ctx, double stepSize, int iterations )
		: mCtx(&ctx), mStepSize(stepSize), mIterations(iterations) { };
	virtual ~CPhysicsStage() { };

	/**
	 *  @param dt Step size for physics integrator.
	 */
	void setStepSize( double dt ) { mStepSize = dt; }
	double getStepSize() const { return mStepSize; }

	/**
	 *  @param it Number of iterations to take. If less than one,
	 *		then non-iterative solver is used.
	 */
	void setIterations( int it ) { mIterations = it; }
	int getIterations() const { return mIterations; }

	// IPipelineStage
	virtual void perform();

	void setContext( CPhysicsContext& ctx ) { mCtx = &ctx; };
	CPhysicsContext* getContext() const { return mCtx; };
	
private:
	CPhysicsContext*	mCtx;
	double		mStepSize;
	int			mIterations;
};


}; // namespace

#endif
