// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "Physicsable.h"

using namespace dingus;


void CPhysicsable::setRotation( const SMatrix4x4& rot )
{
	dMatrix3 tr;
	tr[0] = rot._11;	tr[4] = rot._12;	tr[8] = rot._13;
	tr[1] = rot._21;	tr[5] = rot._22;	tr[9] = rot._23;
	tr[2] = rot._31;	tr[6] = rot._32;	tr[10] = rot._33;
	tr[3] = 0;			tr[4] = 0;			tr[11] = 0;
	dBodySetRotation( mID, tr );
}

void CPhysicsable::getRotation( SMatrix4x4& dest ) const
{
	const double *m = dBodyGetRotation( mID );
	dest._11 = (float)m[0];	dest._12 = (float)m[4];	dest._13 = (float)m[ 8]; dest._14 = 0;
	dest._21 = (float)m[1];	dest._22 = (float)m[5];	dest._23 = (float)m[ 9]; dest._24 = 0;
	dest._31 = (float)m[2];	dest._32 = (float)m[6];	dest._33 = (float)m[10]; dest._34 = 0;
	dest._41 = 0;		dest._42 = 0;		dest._43 = 0;		dest._44 = 1;
}

void CPhysicsable::setMass( const SPhysicsMass& mass )
{
	dMass m;
	m.mass = (float)mass.mass;
	m.c[0] = m.c[1] = m.c[2] = m.c[3] = 0.0;
	m.I[0] = mass.inertiaTensor._11;
	m.I[4] = mass.inertiaTensor._12;
	m.I[8] = mass.inertiaTensor._13;
	m.I[1] = mass.inertiaTensor._21;
	m.I[5] = mass.inertiaTensor._22;
	m.I[9] = mass.inertiaTensor._23;
	m.I[2] = mass.inertiaTensor._31;
	m.I[6] = mass.inertiaTensor._32;
	m.I[10] = mass.inertiaTensor._33;
	dBodySetMass( mID, &m );
}
