// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __FixedRatePipeline_H
#define __FixedRatePipeline_H

#include "Pipeline.h"

namespace dingus {


class CFixedRatePipeline : public CPipeline {
public:
	CFixedRatePipeline( double performFreq = 60.0 ) : mTimeSinceLastUpdate(0) { setPerformFreq(performFreq); }

	virtual void perform();

	void	setPerformFreq( double freq ) { mPerformFreq = freq; mPerformDT = 1.0 / freq; }
	double	getPerformFreq() const { return mPerformFreq; }
	double	getPerformDT() const { return mPerformDT; }

private:
	TStageVector	mStages;
	double			mPerformFreq;
	double			mPerformDT;
	double			mTimeSinceLastUpdate;
};

};


#endif
