// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __PORTAL_H
#define __PORTAL_H

#include "../utils/AbstractNotifier.h"

namespace dingus {

class CPortal;
class CPortalContext;


// --------------------------------------------------------------------------

class IPortalListener {
public:
	virtual ~IPortalListener() = 0 {};

	virtual void onBeforePortal( CPortal const& portal ) = 0;
	virtual void onAfterPortal( CPortal const& portal ) = 0;
};


// --------------------------------------------------------------------------

class CPortal {
public:
	CPortal() : mActive(0), mInside(false) { };
	/*virtual*/ ~CPortal() { };

	/*virtual*/ void render( CPortalContext& ctx );
	
	void addListener( IPortalListener& listener ) { mListeners.addListener(listener); }
	void removeListener( IPortalListener& listener ) { mListeners.removeListener(listener); }

	// TBD

	void	activate() { ++mActive; };
	void	deactivate() { mActive = 0; };
	int		getActivationCount() const { return mActive; };
	bool	isActive() const { return mActive > 0; };

	bool	isInside() const { return mInside; }

private:
	typedef CSimpleNotifier<IPortalListener>	TNotifier;

	void beforePortal( CPortal const& portal ) {
		TNotifier::TListenerVector::iterator it, itEnd = mListeners.getListeners().end();
		for( it = mListeners.getListeners().begin(); it != itEnd; ++it ) {
			assert( *it );
			(*it)->onBeforePortal( portal );
		}
	}
	void afterPortal( CPortal const& portal ) {
		TNotifier::TListenerVector::iterator it, itEnd = mListeners.getListeners().end();
		for( it = mListeners.getListeners().begin(); it != itEnd; ++it ) {
			assert( *it );
			(*it)->onAfterPortal( portal );
		}
	}

private:
	TNotifier	mListeners;
	int			mActive;
	bool		mInside;

	// TBD: different render targets for portals
	//IDirect3DSurface8&	mRenderTarget;
	//IDirect3DSurface8&	mZStencilTarget;
};


}; // namespace

#endif
