// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __PORTAL_CONTEXT_H
#define __PORTAL_CONTEXT_H

namespace dingus {

class CPipeline;
class CPortal;

class CPortalContext {
public:
	typedef std::list<CPortal*>	TPortalContainer;
	
public:
	CPortalContext( CPipeline& portalSubPipeline ) : mPortalSubPipeline(&portalSubPipeline) { };
	/*virtual*/ ~CPortalContext() { };

	void addPortal( CPortal& portal ) { mPortals.push_back(&portal); }
	void removePortal( CPortal& portal ) { mPortals.remove(&portal); }

	CPipeline& getPortalSubPipeline() const { return *mPortalSubPipeline; };
	TPortalContainer const& getPortals() const { return mPortals; }
	TPortalContainer& getPortals() { return mPortals; }

private:
	CPipeline*			mPortalSubPipeline;
	TPortalContainer	mPortals;
};


}; // namespace

#endif
