// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "PortalStage.h"
#include "PortalContext.h"
#include "Portal.h"

using namespace dingus;


void CPortalStage::perform()
{
	assert( mCtx );

	bool active;
	do {
		active = false;
		CPortalContext::TPortalContainer::iterator it, itEnd = mCtx->getPortals().end();
		for( it = mCtx->getPortals().begin(); it != itEnd; ++it ) {
			CPortal* portal = *it;
			assert( portal );
			if( portal->isActive() )
				active = true;

			portal->render( *mCtx );
		};
	} while( active );
}
