// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "EffectSlot.h"

#include "Renderable.h"
#include "../resource/EffectBundle.h"
#include "../resource/ResourceId.h"
#include "../utils/Errors.h"

using namespace dingus;


CEffectSlot* CEffectSlot::createEffectSlot( CResourceId const& id )
{
	CD3DXEffect* fx = CEffectBundle::getInstance().getResourceById( id );

	CEffectSlot* fxSlot = new CEffectSlot( *fx );
	fxSlot->validate();
	return fxSlot;
}

CEffectSlot::CEffectSlot( CD3DXEffect& fx )
:	mEffect( fx )
{
	assert( !mEffect.isNull() );
}


void CEffectSlot::render( CRenderContext& ctx )
{
	assert( !mEffect.isNull() );
	
	UINT passes = 0;
	
	// TBD: ==> apply global params

	// Now, this is weird technique (72FPS @ 215 objects), but it works
	// around current (DX9.0) ID3DXEffect int value bugs. Otherwise, it's better
	// to move Begin()/End() out of the loop.
	// This technique should in other case be used only for multi-pass alpha-blended
	// drawing-order-matters obejcts, in all other cases use the next technique.
	//for each object {
	//	begin effect
	//	set per-object params on effect
	//	for each pass {
	//		pass
	//		render object
	//	}
	//	end effect
	//}

	/*

	// all objects
	TRenderableFVector::iterator itEnd = mRenderables.end();
	TRenderableFVector::iterator it;
	for( it = mRenderables.begin(); it != itEnd; ++it ) {
		// NOTE: due to bug in 9.0 ID3DXEffect, this is inside the loop.
		HRESULT hr = mEffect.getObject()->Begin( &passes, 0 );
		
		CRenderable* r = *it;
		assert( r );

		// if ain't active now - quick shortcut
		if( !r->isActive( ctx ) ) {
			// NOTE: see above
			mEffect.getObject()->End();
			continue;
		}

		r->beforeRender( ctx, *this );

		if( !r->getParams().isEffect() ) {
			r->getParams().setEffect( *mEffect.getObject() );
		}

		r->getParams().applyToEffect();

		// all passes
		for( UINT p = 0; p < passes; ++p ) {
			mEffect.getObject()->Pass( p );
			r->render( ctx, *this );
		}

		r->afterRender( ctx, *this );

		// NOTE: see above
		mEffect.getObject()->End();
	}
	*/

	// This is good weird technique (117FPS @ 215 objects - a 62% faster), but
	// it fails sometimes because of current (DX9.0) ID3DXEffect int value bugs.
	// This technique should not be used for multi-pass alpha-blended
	// drawing-order-matters obejcts; use the above technique in these cases.
	//begin effect
	//for each pass {
	//    pass
	//    for each object {
	//        set per-object params on effect
	//        render object
	//    }
	//}
	//end effect

	mEffect.getObject()->Begin( &passes, 0 );

	// all passes
	for( UINT p = 0; p < passes; ++p ) {
		mEffect.getObject()->Pass( p );

		// all objects
		TRenderableFVector::iterator itEnd = mRenderables.end();
		TRenderableFVector::iterator it;
		for( it = mRenderables.begin(); it != itEnd; ++it ) {
			
			CRenderable* r = *it;
			assert( r );

			// if ain't active now - quick shortcut
			if( !r->isActive( ctx ) ) {
				continue;
			}

			r->beforeRender( ctx, *this );

			if( !r->getParams().isEffect() ) {
				r->getParams().setEffect( *mEffect.getObject() );
			}

			r->getParams().applyToEffect();
			r->render( ctx, *this );
			r->afterRender( ctx, *this );
		}
	}

	mEffect.getObject()->End();
}

void CEffectSlot::notifyChanged()
{
	validate();

	TRenderableFVector::iterator itEnd = mRenderables.end();
	TRenderableFVector::iterator it;
	for( it = mRenderables.begin(); it != itEnd; ++it ) {
		CRenderable* r = *it;
		assert( r );
		r->getParams().setEffect( *mEffect.getObject() );
	}
}

void CEffectSlot::validate()
{
	D3DXHANDLE tech = NULL;
	HRESULT hr = mEffect.getObject()->FindNextValidTechnique( NULL, &tech );
	if( tech != NULL ) {
		mEffect.getObject()->SetTechnique( tech );
		return;
	}

	// no valid technique found, throw exception
	THROW_DXERROR( hr, "No valid techniques found." );
}
