// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __RENDER_CAMERA_H
#define __RENDER_CAMERA_H

#include "../math/Matrix4x4.h"

namespace dingus {


class CRenderCamera {
public:
	CRenderCamera();
	
	void setCameraMatrix( SMatrix4x4 const& matrix );
	void setProjectionMatrix( SMatrix4x4 const& matrix );
	
	SMatrix4x4 const& getCameraMatrix() const { return mCameraMatrix; }
	SMatrix4x4 const& getCameraRotMatrix() const { return mCameraRotMatrix; }
	SMatrix4x4 const& getViewMatrix() const { return mViewMatrix; }
	SMatrix4x4 const& getProjectionMatrix() const { return mProjectionMatrix; };
	SVector4 const& getEye() const { return mEye; }
	SVector3 getEye3() const { return SVector3(mEye.x,mEye.y,mEye.z); }
	
private:
	SMatrix4x4		mCameraMatrix;	
	SMatrix4x4		mProjectionMatrix;

	// calculated basing on camera matrix

	SMatrix4x4		mViewMatrix;
	SMatrix4x4		mCameraRotMatrix;
	SVector4		mEye;
};


}; // namespace


#endif
