// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "RenderContext.h"
#include "../kernel/D3DDevice.h"
#include "../utils/Errors.h"
#include "../resource/EffectBundle.h"
#include "../resource/ResourceId.h"

using namespace dingus;


CRenderContext::CRenderContext()
:	mCurrentFrame( 0 ),
	mGlobalInited( false )
{
	// add-by-ref view & projection matrices to the global params
	mGlobalParams.addMatrix4x4Ref( "mView", mRenderCamera.getViewMatrix() );
	mGlobalParams.addMatrix4x4Ref( "mProjection", mRenderCamera.getProjectionMatrix() );
	mGlobalParams.addVector3Ref( "vEye", mRenderCamera.getCameraMatrix().getOrigin() );

	mStats.reset();
	
	for( int i = 0; i < LAYER_COUNT; ++i )
		mLayers[i] = new CRenderLayer();
}

CRenderContext::~CRenderContext()
{
	for( int i = 0; i < LAYER_COUNT; ++i )
		delete mLayers[i];
}

void CRenderContext::render()
{
	if( !mGlobalInited ) {
		mGlobalEffect = CEffectBundle::getInstance().getResourceById( "_global.fx" );
		assert( mGlobalEffect );
		mGlobalParams.setEffect( *mGlobalEffect->getObject() );
		mGlobalInited = true;
	}

	beforeRendering();

	HRESULT hres;
	
	hres = gD3DDevice->BeginScene();
	if( FAILED( hres ) ) {
		THROW_DXERROR( hres, "failed to begin scene" );
	}

	// global params and effect
	mGlobalParams.applyToEffect();
	UINT passes;
	mGlobalEffect->getObject()->Begin( &passes, 0 );
	for( UINT p = 0; p < 1; ++p ) // just first pass
		mGlobalEffect->getObject()->Pass(p);

	// render
	for( int i = 0; i < LAYER_COUNT; ++i )
		mLayers[i]->render( *this );

	mGlobalEffect->getObject()->End();

	hres = gD3DDevice->EndScene();
	if( FAILED( hres ) ) {
		THROW_DXERROR( hres, "failed to end scene" );
	}

	afterRendering();

	// next frame
	mCurrentFrame.increase();
}


void CRenderContext::notifyChanged()
{
	if( mGlobalInited )
		mGlobalParams.setEffect( *mGlobalEffect->getObject() );
	for( int i = 0; i < LAYER_COUNT; ++i )
		mLayers[i]->notifyChanged();
}
