// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "RenderLayer.h"
#include "RenderContext.h"


using namespace dingus;


CRenderLayer::CRenderLayer()
{
}

CRenderLayer::~CRenderLayer()
{
	clear();
}


CEffectSlot& CRenderLayer::getEffect( CResourceId const& fxID )
{
	TSlotMap::iterator it = mEffectsMap.find( fxID.getUniqueName() );
	if( it == mEffectsMap.end() ) {
		CEffectSlot* effect = CEffectSlot::createEffectSlot( fxID );
		assert( effect );

		mEffectsMap.insert( std::make_pair( fxID, effect ) );
		mEffects.push_back( effect );
		return *effect;
	} else {
		assert( it->second );
		return *it->second;
	}
}

void CRenderLayer::removeRenderable( CRenderable& r, CResourceId const& fxID )
{
	CEffectSlot& slot = getEffect( fxID );
	slot.removeRenderable( r );
	if( slot.isEmpty() )
		mEffectsMap.erase( fxID );
}

void CRenderLayer::removeEffect( CResourceId const& fxID )
{
	TSlotMap::iterator it = mEffectsMap.find( fxID );
	if( it != mEffectsMap.end() ) {
		mEffects.remove( it->second );
		mEffectsMap.erase( it );
		delete it->second;
	}
}

void CRenderLayer::clear()
{
	mEffectsMap.clear();
	stl_utils::wipe( mEffects );
}

void CRenderLayer::render( CRenderContext& ctx )
{
	for( TSlotFVector::iterator it = mEffects.begin(); it != mEffects.end(); ++it ) {
		assert( *it );
		(*it)->render( ctx );
	}
}


void CRenderLayer::notifyChanged()
{
	for( TSlotFVector::iterator it = mEffects.begin(); it != mEffects.end(); ++it ) {
		assert( *it );
		(*it)->notifyChanged();
	}
}