// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __RENDER_STAGE_H
#define __RENDER_STAGE_H

#include "../pipeline/PipelineStage.h"
#include "RenderContext.h"


namespace dingus {


class CRenderStage : public IPipelineStage {
public:
	explicit CRenderStage( CRenderContext& ctx ) : mCtx(&ctx) { };
	virtual ~CRenderStage() { };

	// IPipelineStage
	virtual void perform() { assert(mCtx); mCtx->render(); };

	void setContext( CRenderContext& ctx ) { mCtx = &ctx; };
	CRenderContext* getContext() const { return mCtx; };
	
private:
	CRenderContext*	mCtx;
};


}; // namespace


#endif
