// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __RENDER_STATS_H
#define __RENDER_STATS_H

namespace dingus {


class CRenderStats {
public:
	int		getDrawCalls() const { return mDrawCalls; }
	int		getVerticesRendered() const { return mVerticesRendered; }
	int		getPrimsRendered() const { return mPrimsRendered; }

	void	incDrawCalls( int by = 1 ) { mDrawCalls += by; }
	void	incVerticesRendered( int by ) { mVerticesRendered += by; }
	void	incPrimsRendered( int by ) { mPrimsRendered += by; }

	void	reset() { mDrawCalls = 0; mVerticesRendered = 0; mPrimsRendered = 0; }

private:
	int		mDrawCalls;
	int		mVerticesRendered;
	int		mPrimsRendered;
};


}; // namespace

#endif
