// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "Renderable.h"

using namespace dingus;


void CRenderable::beforeRender( CRenderContext const& ctx, CEffectSlot const& fx )
{
	// dealt in CEffectSlot now
	//if( !isActive(ctx) )
	//	return;

	TListenerVector::iterator it, itEnd = getListeners().end();
	for( it = getListeners().begin(); it != itEnd; ++it ) {
		assert( *it );
		(*it)->beforeRender( *this, fx );
	}
}

void CRenderable::afterRender( CRenderContext const& ctx, CEffectSlot const& fx )
{
	// dealt in CEffectSlot now
	//if( !isActive(ctx) )
	//	return;

	TListenerVector::iterator it, itEnd = getListeners().end();
	for( it = getListeners().begin(); it != itEnd; ++it ) {
		assert( *it );
		(*it)->afterRender( *this, fx );
	}
}

