// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "RenderableMesh.h"
#include "RenderContext.h"
#include "../utils/Errors.h"
#include "../kernel/D3DDevice.h"


using namespace dingus;


CRenderableMesh::CRenderableMesh( DWORD attrId, CD3DXMesh& mesh )
:	mAttrId( attrId ),
	mMesh( &mesh )
{
	ID3DXMesh* m = mesh.getObject();
	assert( m );

	DWORD attrCount;
	m->GetAttributeTable( NULL, &attrCount );

	if( attrCount == 0 ) {
		// no attribute table
		// render all mesh at once
		mAttrRange.AttribId = 0;
		mAttrRange.VertexStart = 0;
		mAttrRange.VertexCount = m->GetNumVertices();
		mAttrRange.FaceStart = 0;
		mAttrRange.FaceCount = m->GetNumFaces();
	} else {
		// attribute table exists
		// find range for attrId
		D3DXATTRIBUTERANGE* attrs = new D3DXATTRIBUTERANGE[attrCount];
		m->GetAttributeTable( attrs, &attrCount );
		bool attrIdFound = false;
		for( int q = 0; q < attrCount; q++ ) {
			if( attrs[q].AttribId == attrId ) {
				mAttrRange = attrs[q];
				attrIdFound = true;
				break;
			}
		}
		delete[] attrs;
		assert( attrIdFound );
	}

	mStride = m->GetNumBytesPerVertex();
}


void CRenderableMesh::renderContent( CRenderContext const& ctx, CEffectSlot const& fx )
{
	assert( mAttrRange.AttribId == mAttrId );

	HRESULT hres;
	IDirect3DIndexBuffer9* ib = NULL;
	IDirect3DVertexBuffer9* vb = NULL;
	hres = mMesh->getObject()->GetIndexBuffer( &ib );
	if( !SUCCEEDED( hres ) ) {
		THROW_DXERROR( hres, "failed to get IB of mesh" );
	}
	hres = mMesh->getObject()->GetVertexBuffer( &vb );
	if( !SUCCEEDED( hres ) ) {
		THROW_DXERROR( hres, "failed to get VB of mesh" );
	}

	IDirect3DDevice9* dx = gD3DDevice;
	
	hres = dx->SetIndices( ib );
	if( !SUCCEEDED( hres ) ) {
		THROW_DXERROR( hres, "failed to set IB" );
	}

	hres = dx->SetStreamSource( 0, vb, 0, mStride );
	if( !SUCCEEDED( hres ) ) {
		THROW_DXERROR( hres, "failed to set VB" );
	}

	hres = dx->DrawIndexedPrimitive( 
		D3DPT_TRIANGLELIST,
		0,
		mAttrRange.VertexStart,
		mAttrRange.VertexCount,
		mAttrRange.FaceStart * 3,
		mAttrRange.FaceCount );
	if( FAILED( hres ) ) {
		THROW_DXERROR( hres, "failed to DIP" );
	}

	dx->SetStreamSource( 0, NULL, 0, 0 );
	dx->SetIndices( NULL );
	vb->Release();
	ib->Release();

	// stats
	ctx.getStats().incDrawCalls();
	ctx.getStats().incVerticesRendered( mAttrRange.VertexCount );
	ctx.getStats().incPrimsRendered( mAttrRange.FaceCount );
}
