// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __RENDER_MESH_H
#define __RENDER_MESH_H

#include "Renderable.h"
#include "../kernel/Proxies.h"


namespace dingus {


class CRenderableMesh : public CRenderable {
public:
	CRenderableMesh( DWORD attrId, CD3DXMesh& mesh );

	DWORD getAttrId() const { return mAttrId; }
	CD3DXMesh& getMesh() const { return *mMesh; }

	virtual void renderContent( CRenderContext const& ctx, CEffectSlot const& fx );
	
private:
	DWORD				mAttrId;
	CD3DXMesh*			mMesh;

	D3DXATTRIBUTERANGE	mAttrRange;
	unsigned int		mStride;
};


}; // namespace


#endif
