// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __COL_MESH_BUNDLE_H
#define __COL_MESH_BUNDLE_H

#include "../collider-ode/CollisionMesh.h"
#include "BundleSingleton.h"
#include "StorageResourceBundle.h"
#include "ReloadableBundle.h"

//#include "BundleResourceProvider.h"
//#include "ResourceProviders.h"

namespace dingus {


class CCollisionMeshBundle : public CStorageResourceBundle<CCollisionMesh>,
					public CBundleSingleton<CCollisionMeshBundle>,
					public IReloadableBundle
{
public:
	static void init( const std::string& predir = "" ) {
		CCollisionMeshBundle* bundle = new CCollisionMeshBundle( predir );
		assert( bundle );
		assignInstance( *bundle );
	}

	const std::string& getPreDir() const { return mPreDir; }

	virtual void reload();

protected:
	virtual CCollisionMesh* loadResourceById( CResourceId const& id );
	virtual void clearResource( CCollisionMesh& resource );
	virtual void deleteResource( CCollisionMesh& resource ) { delete &resource; }
	
private:
	CCollisionMeshBundle( const std::string& predir = "" ) : mPreDir(predir) { };
	virtual ~CCollisionMeshBundle() { clear(); };
	friend CBundleSingleton<CCollisionMeshBundle>;
	
	void loadMesh( CResourceId const& id, CCollisionMesh& dest ) const;

private:
	const std::string	mPreDir;
};


//DEFINE_BUNDLE_RESOURCE_PROVIDER( CStorageMeshProvider, TMeshProvider, CCollisionMeshBundle );


}; // namespace

#endif
