// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __EFFECT_BUNDLE_H
#define __EFFECT_BUNDLE_H

#include "BundleSingleton.h"
#include "StorageResourceBundle.h"
#include "../kernel/Proxies.h"
#include "DeviceResource.h"

//#include "BundleResourceProvider.h"
//#include "ResourceProviders.h"

namespace dingus {


class CEffectBundle :	public CStorageResourceBundle<CD3DXEffect>,
						public CBundleSingleton<CEffectBundle>,
						public IDeviceReloadableBundle
{
public:
	static void init( const std::string& predir = "" ) {
		CEffectBundle* bundle = new CEffectBundle( predir );
		assert( bundle );
		assignInstance( *bundle );
	}

	const std::string& getPreDir() const { return mPreDir; }

	virtual void createResource();
	virtual void activateResource();
	virtual void passivateResource();
	virtual void deleteResource();

protected:
	virtual CD3DXEffect* loadResourceById( CResourceId const& id );
	virtual void clearResource( CD3DXEffect& resource );
	virtual void deleteResource( CD3DXEffect& resource ) { delete &resource; }
	
private:
	CEffectBundle( const std::string& predir = "" ) : mPreDir(predir), mSharedPool(0) { };
	virtual ~CEffectBundle() { clear(); };
	friend CBundleSingleton<CEffectBundle>;
	
	ID3DXEffect* loadEffect( CResourceId const& id ) const;

private:
	const std::string	mPreDir;
	ID3DXEffectPool*	mSharedPool;
};


//DEFINE_BUNDLE_RESOURCE_PROVIDER( CStorageEffectProvider, TEffectProvider, CEffectBundle );


}; // namespace

#endif
