// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __LUA_WRAPPER_BUNDLE_H
#define __LUA_WRAPPER_BUNDLE_H

#include "../lua/LuaWrapper.h"
#include "BundleSingleton.h"
#include "ResourceBundle.h"
#include "ResourceId.h"


namespace dingus {

class CLuaWrapperBundle :	public IResourceBundle<CLuaWrapper>,
							public CBundleSingleton<CLuaWrapperBundle>
{
public:
	static void init( const std::string& predir = "" ) {
		CLuaWrapperBundle* bundle = new CLuaWrapperBundle( predir );
		assert( bundle );
		assignInstance( *bundle );
	}
private:
	typedef std::map<CResourceId, CLuaWrapper*>	TResourceMap;
	
public:
	
	CLuaWrapper* getResourceById( CResourceId const& id )	{
		CLuaWrapper* resource = findResource( id );
		if( !resource ) {
			resource = new CLuaWrapper(mPreDir);
			assert( resource );
			mResourceMap.insert( std::make_pair( id, resource ) );
		}
		return resource;
	}

	void clear() {
		for( TResourceMap::iterator it = mResourceMap.begin(); it != mResourceMap.end(); ) {
			assert( it->second );
			delete it->second;
			it = mResourceMap.erase( it );
		}
	}
			
protected:
	CLuaWrapper* findResource( CResourceId const& id ) {
		TResourceMap::const_iterator it = mResourceMap.find( id );
		return ( it != mResourceMap.end() ) ? it->second : NULL;
	}
private:
	CLuaWrapperBundle( const std::string& preDir ) : mPreDir(preDir) { };
	virtual ~CLuaWrapperBundle() { clear(); }
	friend CBundleSingleton<CLuaWrapperBundle>;

protected:
	TResourceMap	mResourceMap;
	std::string		mPreDir;
};




}; // namespace

#endif
