// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "MeshBundle.h"
#include "../utils/Errors.h"
#include "../kernel/D3DDevice.h"

using namespace dingus;



ID3DXMesh* CMeshBundle::loadMesh( CResourceId const& id ) const
{
	ID3DXBuffer* adjancency = NULL;
	ID3DXBuffer* material = NULL;
	ID3DXBuffer* effects = NULL;
	DWORD matCount;
	ID3DXMesh* mesh = NULL;

	HRESULT hres = D3DXLoadMeshFromX(
		(mPreDir + id.getUniqueName()).c_str(),
		D3DXMESH_MANAGED,
		gD3DDevice,
		&adjancency,
		&material,
		&effects,
		&matCount,
		&mesh );
	if( !SUCCEEDED( hres ) ) {
		std::string msg = "failed to load mesh '" + id.getUniqueName() + "'";
		CConsole::CON_ERROR.write(msg);
		THROW_DXERROR( hres, msg );
	}
	assert( mesh );
	CONSOLE.write( "mesh loaded '" + id.getUniqueName() + "'" );

	if( adjancency )
		adjancency->Release();
	if( material ) {
		material->Release();
	}
	if( effects ) {
		effects->Release();
	}
	return mesh;
}

CD3DXMesh* CMeshBundle::loadResourceById( CResourceId const& id )
{
	ID3DXMesh* mesh = loadMesh( id );
	return new CD3DXMesh( mesh );
}

void CMeshBundle::clearResource( CD3DXMesh& resource )
{
	ULONG refs = resource.getObject()->Release();
}


void CMeshBundle::createResource()
{
	// reload all objects
	TResourceMap::iterator it;
	for( it = mResourceMap.begin(); it != mResourceMap.end(); ++it ) {
		CD3DXMesh& res = *reinterpret_cast<CD3DXMesh*>(it->second);
		assert( res.isNull() );
		res.setObject( loadMesh( it->first ) );
		assert( !res.isNull() );
	}
}

void CMeshBundle::activateResource()
{
}

void CMeshBundle::passivateResource()
{
}

void CMeshBundle::deleteResource()
{
	// unload all objects
	TResourceMap::iterator it;
	for( it = mResourceMap.begin(); it != mResourceMap.end(); ++it ) {
		CD3DXMesh& res = *reinterpret_cast<CD3DXMesh*>(it->second);
		assert( !res.isNull() );
		clearResource( res );
		res.setObject( NULL );
	}
}

