// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __MESH_BUNDLE_H
#define __MESH_BUNDLE_H

#include "BundleSingleton.h"
#include "StorageResourceBundle.h"
#include "../kernel/Proxies.h"
#include "DeviceResource.h"

//#include "BundleResourceProvider.h"
//#include "ResourceProviders.h"

namespace dingus {


class CMeshBundle :	public CStorageResourceBundle<CD3DXMesh>,
					public CBundleSingleton<CMeshBundle>,
					public IDeviceReloadableBundle
{
public:
	static void init( const std::string& predir = "" ) {
		CMeshBundle* bundle = new CMeshBundle( predir );
		assert( bundle );
		assignInstance( *bundle );
	}

	const std::string& getPreDir() const { return mPreDir; }

	virtual void createResource();
	virtual void activateResource();
	virtual void passivateResource();
	virtual void deleteResource();

protected:
	virtual CD3DXMesh* loadResourceById( CResourceId const& id );
	virtual void clearResource( CD3DXMesh& resource );
	virtual void deleteResource( CD3DXMesh& resource ) { delete &resource; }
	
private:
	CMeshBundle( const std::string& predir = "" ) : mPreDir(predir) { };
	virtual ~CMeshBundle() { clear(); };
	friend CBundleSingleton<CMeshBundle>;
	
	ID3DXMesh* loadMesh( CResourceId const& id ) const;

private:
	const std::string	mPreDir;
};


//DEFINE_BUNDLE_RESOURCE_PROVIDER( CStorageMeshProvider, TMeshProvider, CMeshBundle );


}; // namespace

#endif
