// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __RESOURCE_BUNDLE_H
#define __RESOURCE_BUNDLE_H

#include "ResourceId.h"
#include "../console/Console.h"

namespace dingus {

class IBaseResourceBundle {
public:
	static CConsoleChannel& CONSOLE;
};


template<typename T>
class IResourceBundle : public IBaseResourceBundle {
public:
	virtual ~IResourceBundle() = 0 {};

	/** Returns resource, loads if necessary. */
	virtual T* getResourceById( CResourceId const& id ) = 0;
};



}; // namespace

#endif
