// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __RESOURCE_PROVIDER_H
#define __RESOURCE_PROVIDER_H

namespace dingus {

// TBD: so far all this is only relevanto Surface Providers in unco.


/**
 *  An object that is able to provide some resource.
 *
 *  Used for abstracting resource acquisition - for something that needs
 *  some type of resource, supply any derived object. This way resources
 *  can be fetched from corresponding Bundles, from some global objects, etc.
 *
 *  @param T Resource type.
 */
template<class T>
class IResourceProvider {
public:
	typedef T resource_type;

public:
	virtual ~IResourceProvider() = 0 {};

	/**
	 *  Clones this provider - returns another object that provides the
	 *  same resource.
	 */
	virtual IResourceProvider* clone() const = 0;

	/**
	 *  Gets the resource.
	 */
	virtual resource_type* getResource() = 0;
};

}; // namespace

#endif
