// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __SHARED_RESOURCE_BUNDLE_H
#define __SHARED_RESOURCE_BUNDLE_H

#include "ResourceBundle.h"
#include "ResourceId.h"

namespace dingus {

template<typename T, typename RESDATA>
class CSharedResourceBundle : public IResourceBundle<T> {
private:
	// HACK: should be T*, but here is int* for code size reasons :)
	typedef std::map<CResourceId, std::pair<RESDATA,int*> >	TResourceMap;
	//typedef std::map<CResourceId, T*>	TResourceMap;
	
public:
	CSharedResourceBundle() {}
	virtual ~CSharedResourceBundle() { }
	
	T* getResourceById( CResourceId const& id )	{
		T* resource = findResource( id );
		assert( resource );
		return resource;
	}

	void clear() {
		for( TResourceMap::iterator it = mResourceMap.begin(); it != mResourceMap.end(); ) {
			assert( (*it).second.second );
			deleteResource( *reinterpret_cast<T*>( (*it).second.second ) );
			it = mResourceMap.erase( it );
		}
	}
			
protected:
	void registerResource( CResourceId const& id, T& resource, const RESDATA& data ) {
		mResourceMap.insert( std::make_pair( id, std::make_pair(data, reinterpret_cast<int*>(&resource) ) ) );
	}

	T* findResource( CResourceId const& id ) {
		TResourceMap::const_iterator it = mResourceMap.find( id );
		return ( ( it != mResourceMap.end() ) ? reinterpret_cast<T*>((*it).second.second) : NULL );
	}

	virtual void deleteResource( T& resource ) = 0;	
		
protected:
	TResourceMap	mResourceMap;
};

}; // namespace

#endif
