// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "SharedSurfaceBundle.h"
#include "../utils/Errors.h"
#include "../kernel/D3DDevice.h"

using namespace dingus;



void CSharedSurfaceBundle::registerDepthStencilSurface( CResourceId const& id,
		int width, int height, D3DFORMAT format, D3DMULTISAMPLE_TYPE msType, DWORD msQuality, bool discardable )
{
	SSurfaceDescriptor desc;
	desc.width = width;
	desc.height = height;
	desc.format = format;
	desc.msType = msType;
	desc.msQuality = msQuality;
	desc.discardableLockable = discardable;
	desc.depthStencil = true;
	IDirect3DSurface9* tex = createSurface( desc );
	registerResource( id, *(new CD3DSurface(tex)), desc );
}

void CSharedSurfaceBundle::registerRenderTargetSurface( CResourceId const& id,
		int width, int height, D3DFORMAT format, D3DMULTISAMPLE_TYPE msType, DWORD msQuality, bool lockable )
{
	SSurfaceDescriptor desc;
	desc.width = width;
	desc.height = height;
	desc.format = format;
	desc.msType = msType;
	desc.msQuality = msQuality;
	desc.discardableLockable = lockable;
	desc.depthStencil = false;
	IDirect3DSurface9* tex = createSurface( desc );
	registerResource( id, *(new CD3DSurface(tex)), desc );
}


IDirect3DSurface9* CSharedSurfaceBundle::createSurface( const SSurfaceDescriptor& d  ) const
{
	HRESULT hres;
	IDirect3DSurface9* surface = NULL;
	
	if( d.depthStencil ) {
		hres = gD3DDevice->CreateDepthStencilSurface(
			d.width, d.height,
			d.format, d.msType,
			d.msQuality, d.discardableLockable,
			&surface, NULL );
	} else {
		hres = gD3DDevice->CreateRenderTarget(
			d.width, d.height,
			d.format, d.msType,
			d.msQuality, d.discardableLockable,
			&surface, NULL );
	}
	if( FAILED( hres ) ) {
		std::string msg = "Failed to create surface";
		CConsole::CON_ERROR.write(msg);
		THROW_DXERROR( hres, msg );
	}
	assert( surface );
	return surface;
}

void CSharedSurfaceBundle::clearResource( CD3DSurface& resource )
{
	resource.getObject()->Release();
}

void CSharedSurfaceBundle::createResource()
{
}

void CSharedSurfaceBundle::activateResource()
{
	// recreate all objects
	TResourceMap::iterator it;
	for( it = mResourceMap.begin(); it != mResourceMap.end(); ++it ) {
		SSurfaceDescriptor& desc = it->second.first;
		CD3DSurface& res = *reinterpret_cast<CD3DSurface*>(it->second.second);
		if( !res.isNull() )
			continue; // kind of HACK
		res.setObject( createSurface( desc ) );
		assert( !res.isNull() );
	}
}

void CSharedSurfaceBundle::passivateResource()
{
	// unload all objects
	TResourceMap::iterator it;
	for( it = mResourceMap.begin(); it != mResourceMap.end(); ++it ) {
		CD3DSurface& res = *reinterpret_cast<CD3DSurface*>(it->second.second);
		assert( !res.isNull() );
		clearResource( res );
		res.setObject( NULL );
	}
}

void CSharedSurfaceBundle::deleteResource()
{
}
