// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#pragma warning(disable:4786)
#ifndef __SHARED_SURFACE_BUNDLE_H
#define __SHARED_SURFACE_BUNDLE_H

#include "BundleSingleton.h"
#include "SharedResourceBundle.h"
#include "../kernel/Proxies.h"
#include "DeviceResource.h"

//#include "BundleResourceProvider.h"
//#include "ResourceProviders.h"

namespace dingus {


struct SSurfaceDescriptor {
	int			width, height;
	D3DFORMAT	format;
	D3DMULTISAMPLE_TYPE	msType;
	DWORD		msQuality;
	bool		discardableLockable; // discardable? for DSs, lockable? for RTs
	bool		depthStencil;
};


class CSharedSurfaceBundle :public CSharedResourceBundle<CD3DSurface,SSurfaceDescriptor>,
							public CBundleSingleton<CSharedSurfaceBundle>,
							public IDeviceResource
{
public:
	static void init() {
		CSharedSurfaceBundle* bundle = new CSharedSurfaceBundle();
		assert( bundle );
		assignInstance( *bundle );
	}

	void registerDepthStencilSurface(
		CResourceId const& id,
		int width, int height, D3DFORMAT format, D3DMULTISAMPLE_TYPE msType, DWORD msQuality, bool discardable );
	void registerRenderTargetSurface(
		CResourceId const& id,
		int width, int height, D3DFORMAT format, D3DMULTISAMPLE_TYPE msType, DWORD msQuality, bool lockable );

	virtual void createResource();
	virtual void activateResource();
	virtual void passivateResource();
	virtual void deleteResource();

protected:
	virtual void clearResource( CD3DSurface& resource );
	virtual void deleteResource( CD3DSurface& resource ) { delete &resource; }

private:
	CSharedSurfaceBundle() { };
	virtual ~CSharedSurfaceBundle() { clear(); };
	friend CBundleSingleton<CSharedSurfaceBundle>;
	IDirect3DSurface9* createSurface( const SSurfaceDescriptor& d ) const;
};

//DEFINE_BUNDLE_RESOURCE_PROVIDER( CSharedTextureProvider, TTextureProvider, CSharedSurfaceBundle );

}; // namespace

#endif
