// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "SharedTextureBundle.h"
#include "../utils/Errors.h"
#include "../kernel/D3DDevice.h"

using namespace dingus;



void CSharedTextureBundle::registerTexture( CResourceId const& id,
		int width, int height, int levels, DWORD usage, D3DFORMAT format, D3DPOOL pool )
{
	STextureDescriptor desc;
	desc.width = width;
	desc.height = height;
	desc.levels = levels;
	desc.usage = usage;
	desc.format = format;
	desc.pool = pool;
	IDirect3DTexture9* tex = createTexture( desc );
	registerResource( id, *(new CD3DTexture(tex)), desc );
}


IDirect3DTexture9* CSharedTextureBundle::createTexture( const STextureDescriptor& d  ) const
{
	HRESULT hres;
	IDirect3DTexture9* texture = NULL;
	
	hres = gD3DDevice->CreateTexture(
		d.width, d.height,
		d.levels, d.usage,
		d.format, d.pool,
		&texture, NULL );
	if( FAILED( hres ) ) {
		std::string msg = "failed to create texture";
		CConsole::CON_ERROR.write(msg);
		THROW_DXERROR( hres, msg );
	}
	assert( texture );
	return texture;
}

void CSharedTextureBundle::clearResource( CD3DTexture& resource )
{
	resource.getObject()->Release();
}

void CSharedTextureBundle::createResource()
{
}

void CSharedTextureBundle::activateResource()
{
	// recreate all objects
	TResourceMap::iterator it;
	for( it = mResourceMap.begin(); it != mResourceMap.end(); ++it ) {
		STextureDescriptor& desc = it->second.first;
		CD3DTexture& res = *reinterpret_cast<CD3DTexture*>(it->second.second);
		if( !res.isNull() )
			continue; // kind of HACK
		res.setObject( createTexture( desc ) );
		assert( !res.isNull() );
	}
}

void CSharedTextureBundle::passivateResource()
{
	// unload all objects
	TResourceMap::iterator it;
	for( it = mResourceMap.begin(); it != mResourceMap.end(); ++it ) {
		CD3DTexture& res = *reinterpret_cast<CD3DTexture*>(it->second.second);
		assert( !res.isNull() );
		clearResource( res );
		res.setObject( NULL );
	}
}

void CSharedTextureBundle::deleteResource()
{
}
