// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#pragma warning(disable:4786)
#ifndef __SHARED_TEXTURE_BUNDLE_H
#define __SHARED_TEXTURE_BUNDLE_H

#include "BundleSingleton.h"
#include "SharedResourceBundle.h"
#include "../kernel/Proxies.h"
#include "DeviceResource.h"

//#include "BundleResourceProvider.h"
//#include "ResourceProviders.h"

namespace dingus {


struct STextureDescriptor {
	int			width, height, levels;
	DWORD		usage;
	D3DFORMAT	format;
	D3DPOOL		pool;
};


class CSharedTextureBundle :	public CSharedResourceBundle<CD3DTexture,STextureDescriptor>,
								public CBundleSingleton<CSharedTextureBundle>,
								public IDeviceResource
{
public:
	static void init() {
		CSharedTextureBundle* bundle = new CSharedTextureBundle();
		assert( bundle );
		assignInstance( *bundle );
	}

	void registerTexture(
		CResourceId const& id,
		int width, int height, int levels, DWORD usage, D3DFORMAT format, D3DPOOL pool );

	virtual void createResource();
	virtual void activateResource();
	virtual void passivateResource();
	virtual void deleteResource();

protected:
	virtual void clearResource( CD3DTexture& resource );
	virtual void deleteResource( CD3DTexture& resource ) { delete &resource; }

private:
	CSharedTextureBundle() { };
	virtual ~CSharedTextureBundle() { clear(); };
	friend CBundleSingleton<CSharedTextureBundle>;
	IDirect3DTexture9* createTexture( const STextureDescriptor& d ) const;
};

//DEFINE_BUNDLE_RESOURCE_PROVIDER( CSharedTextureProvider, TTextureProvider, CSharedTextureBundle );

}; // namespace

#endif
