// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __STORAGE_RESOURCE_BUNDLE_H
#define __STORAGE_RESOURCE_BUNDLE_H

#include "ResourceBundle.h"
#include "ResourceId.h"


namespace dingus {

template<class T>
class CStorageResourceBundle : public IResourceBundle<T> {
private:
	// HACK: should be T*, but here is int* for code size reasons :)
	typedef std::map<CResourceId, int*>	TResourceMap;
	//typedef std::map<CResourceId, T*>	TResourceMap;
	
public:
	CStorageResourceBundle() {}
	virtual ~CStorageResourceBundle() = 0 {}
	
	T* getResourceById( CResourceId const& id )	{
		T* resource = findResource( id );
		
		if( !resource ) {
			resource = loadResourceById( id );
			assert( resource );
			mResourceMap.insert( std::make_pair( id, reinterpret_cast<int*>(resource) ) );
		}
		return resource;
	}
	
	void clear() {
		for( TResourceMap::iterator it = mResourceMap.begin(); it != mResourceMap.end(); ) {
			assert( (*it).second );
			deleteResource( *reinterpret_cast<T*>( (*it).second ) );
			it = mResourceMap.erase( it );
		}
	}
	
protected:
	T* findResource( CResourceId const& id ) {
		TResourceMap::const_iterator it = mResourceMap.find( id );
		return ( ( it != mResourceMap.end() ) ? reinterpret_cast<T*>((*it).second) : NULL );
	}

	virtual T* loadResourceById( CResourceId const& id ) = 0;
	virtual void deleteResource( T& resource ) = 0;	
	
protected:
	TResourceMap	mResourceMap;
};

}; // namespace


#endif
