// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "TextureBundle.h"
#include "../utils/Errors.h"
#include "../kernel/D3DDevice.h"

using namespace dingus;



IDirect3DTexture9* CTextureBundle::loadTexture( CResourceId const& id ) const
{
	IDirect3DTexture9* texture = NULL;
	HRESULT hres = D3DXCreateTextureFromFileEx(
		gD3DDevice,
		( mPreDir + id.getUniqueName() ).c_str(),
		D3DX_DEFAULT, D3DX_DEFAULT,
		0,	// mipLevels
		0,
		D3DFMT_UNKNOWN,
		D3DPOOL_MANAGED,
		D3DX_DEFAULT,
		D3DX_DEFAULT,
		0,
		NULL,
		NULL,
		&texture );
	
	if( !SUCCEEDED( hres ) ) {
		std::string msg = "failed to load texture '" + id.getUniqueName() + "'";
		CConsole::CON_ERROR.write(msg);
		THROW_DXERROR( hres, msg );
	}

	assert( texture );
	CONSOLE.write( "texture loaded '" + id.getUniqueName() + "'" );
	return texture;
}

CD3DTexture* CTextureBundle::loadResourceById( CResourceId const& id )
{
	IDirect3DTexture9* texture = loadTexture( id );
	return new CD3DTexture( texture );
}

void CTextureBundle::clearResource( CD3DTexture& resource )
{
	resource.getObject()->Release();
}


void CTextureBundle::createResource()
{
	// reload all objects
	TResourceMap::iterator it;
	for( it = mResourceMap.begin(); it != mResourceMap.end(); ++it ) {
		CD3DTexture& res = *reinterpret_cast<CD3DTexture*>(it->second);
		assert( res.isNull() );
		res.setObject( loadTexture( it->first ) );
		assert( !res.isNull() );
	}
}

void CTextureBundle::activateResource()
{
}

void CTextureBundle::passivateResource()
{
}

void CTextureBundle::deleteResource()
{
	// unload all objects
	TResourceMap::iterator it;
	for( it = mResourceMap.begin(); it != mResourceMap.end(); ++it ) {
		CD3DTexture& res = *reinterpret_cast<CD3DTexture*>(it->second);
		assert( !res.isNull() );
		clearResource( res );
		res.setObject( NULL );
	}
}

