// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "VertexDeclBundle.h"
#include "../utils/Errors.h"
#include "../kernel/D3DDevice.h"


using namespace dingus;



CVertexDesc::CVertexDesc( const D3DVERTEXELEMENT9* e )
{
	D3DVERTEXELEMENT9 end = D3DDECL_END();
	--e;
	do {
		++e;
		mElements.push_back( *e );
	} while( memcmp(e,&end, sizeof(D3DVERTEXELEMENT9) ) );
}


void CVertexDeclBundle::registerDecl( CResourceId const& id,
		const D3DVERTEXELEMENT9* elems )
{
	CVertexDesc desc( elems );
	IDirect3DVertexDeclaration9* decl = createDecl( desc );
	registerResource( id, *(new CD3DVertexDecl(decl)), desc );
}


IDirect3DVertexDeclaration9* CVertexDeclBundle::createDecl( const CVertexDesc& d ) const
{
	HRESULT hres;
	IDirect3DVertexDeclaration9* decl = NULL;
	
	hres = gD3DDevice->CreateVertexDeclaration(
		d.getElementsPtr(),
		&decl );
	if( FAILED( hres ) ) {
		std::string msg = "failed to create vertex decl";
		CConsole::CON_ERROR.write(msg);
		THROW_DXERROR( hres, msg );
	}
	assert( decl );
	return decl;
}

void CVertexDeclBundle::clearResource( CD3DVertexDecl& resource )
{
	resource.getObject()->Release();
}

void CVertexDeclBundle::createResource()
{
	// recreate all objects
	TResourceMap::iterator it;
	for( it = mResourceMap.begin(); it != mResourceMap.end(); ++it ) {
		CVertexDesc& desc = it->second.first;
		CD3DVertexDecl& res = *reinterpret_cast<CD3DVertexDecl*>(it->second.second);
		res.setObject( createDecl( desc ) );
		assert( !res.isNull() );
	}
}

void CVertexDeclBundle::activateResource()
{
}

void CVertexDeclBundle::passivateResource()
{
}

void CVertexDeclBundle::deleteResource()
{
	// unload all objects
	TResourceMap::iterator it;
	for( it = mResourceMap.begin(); it != mResourceMap.end(); ++it ) {
		CD3DVertexDecl& res = *reinterpret_cast<CD3DVertexDecl*>(it->second.second);
		assert( !res.isNull() );
		clearResource( res );
		res.setObject( NULL );
	}
}
