// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __VERTEX_DECL_BUNDLE_H
#define __VERTEX_DECL_BUNDLE_H

#include "BundleSingleton.h"
#include "SharedResourceBundle.h"
#include "../kernel/Proxies.h"
#include "DeviceResource.h"

//#include "BundleResourceProvider.h"
//#include "ResourceProviders.h"

namespace dingus {


class CVertexDesc {
public:
	typedef std::vector<D3DVERTEXELEMENT9>	TElementVector;

public:
	CVertexDesc() : mElements() { }
	CVertexDesc( const CVertexDesc& r ) : mElements(r.mElements) { }
	CVertexDesc( const D3DVERTEXELEMENT9* e );
	CVertexDesc const& operator=( const CVertexDesc& r ) { mElements = r.mElements; }

	D3DVERTEXELEMENT9 const* getElementsPtr() const { return &mElements[0]; }

	TElementVector const& getElements() const { return mElements; }
	TElementVector& getElements() { return mElements; }
	
private:
	TElementVector	mElements;
};



class CVertexDeclBundle :	public CSharedResourceBundle<CD3DVertexDecl,CVertexDesc>,
							public CBundleSingleton<CVertexDeclBundle>,
							public IDeviceResource
{
public:
	static void init() {
		CVertexDeclBundle* bundle = new CVertexDeclBundle();
		assert( bundle );
		assignInstance( *bundle );
	}

	void registerDecl(
		CResourceId const& id,
		const D3DVERTEXELEMENT9* elems );

	virtual void createResource();
	virtual void activateResource();
	virtual void passivateResource();
	virtual void deleteResource();

protected:
	virtual void clearResource( CD3DVertexDecl& resource );
	virtual void deleteResource( CD3DVertexDecl& resource ) { delete &resource; }

private:
	CVertexDeclBundle() { };
	virtual ~CVertexDeclBundle() { clear(); };
	friend CBundleSingleton<CVertexDeclBundle>;
	IDirect3DVertexDeclaration9* createDecl( const CVertexDesc&d ) const;
};

//DEFINE_BUNDLE_RESOURCE_PROVIDER( CVertexDeclProvider, TDeclProvider, CVertexDeclBundle );

}; // namespace

#endif
