// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __ERRORS_H
#define __ERRORS_H

#include <stdexcept>
//#include "utils.h"
namespace dingus {

#define BASE_ERROR_PARAMS			__FILE__, __LINE__
#define THROW_ERROR(msg)			throw dingus::EBaseError( msg, BASE_ERROR_PARAMS )
#define THROW_DXERROR(result,msg)	throw dingus::EDXError( result, msg, BASE_ERROR_PARAMS )
//#define THROW_NETERROR(result,msg)	throw dingus::ENetworkError( result, msg, BASE_ERROR_PARAMS )


class EBaseError : public std::runtime_error {
public:
	EBaseError( const std::string& msg, const std::string& fileName, int lineNumber )
	:	std::runtime_error( msg ),
		mFileName( fileName ),
		mLineNumber( lineNumber ) {
		mWhereMsg = "file: " + mFileName; };

	// mimick the runtime_error style
	virtual const char* where() const {	return mWhereMsg.c_str(); }

	std::string const& getFileName() const { return mFileName; }
	int getLineNumber() const { return mLineNumber; }

protected:
	std::string			mWhereMsg;
	std::string const	mFileName;
	int const			mLineNumber;
};

class EDXError : public EBaseError {
public:
	EDXError( HRESULT dxresult, const std::string msg, const std::string fileName, int lineNumber )
	:	EBaseError( msg, fileName, lineNumber ),
		mDXResult( dxresult ) {};

	HRESULT const& getDXResult() const { return mDXResult; };

private:
	HRESULT	const	mDXResult;
};


}; // namespace

#endif // __ERRORS_H