// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __RANDOM_H__
#define __RANDOM_H__

namespace dingus {

/**
 *  Returns random number [0..interv)
 */
inline float random( float interv = 1.0 )
{
	return (float)rand() / RAND_MAX * interv;
};

/**
 *  Returns random number [from..to)
 */
inline float random( float from, float to )
{
	return random( to - from ) + from;
};


}; // namespace

#endif 
