// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __SINGLETON_H
#define __SINGLETON_H

namespace dingus {

template<typename T>
class CSingleton {
public:
	static T& getInstance() {
		if( !isCreated() )
			mSingleInstance = T::createInstance();
		return *mSingleInstance;
	}

	static void finalize() {
		if( !isCreated() )
			return;
		T::deleteInstance( *mSingleInstance );
		mSingleInstance = 0;
	}

protected:
	static void assignInstance( T& instance ) { mSingleInstance = &instance; }
	static bool isCreated() { return ( mSingleInstance != NULL ); }

private:
	static T*	mSingleInstance;
};


template< typename T >
T* CSingleton<T>::mSingleInstance = 0;

}; // namespace

#endif
