// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "StringHelper.h"

using namespace dingus;


void CStringHelper::replaceTabs( std::string& s ) {
	int n = s.size();
	for( int i = 0; i < n; ++i ) {
		if( s[i] == '\t' ) s[i] = ' ';
	}
}

void CStringHelper::replaceLineEnds( std::string& s )
{
	int n = s.size();
	for( int i = 0; i < n; ++i ) {
		if( s[i]=='\n' || s[i]=='\r' ) s[i] = ' ';
	}
}

void CStringHelper::replaceWhitespace( std::string& s )
{
	int n = s.size();
	for( int i = 0; i < n; ++i ) {
		if( !isprint(s[i]) ) s[i] = ' ';
	}
}

void CStringHelper::trimString( std::string& s ) 
{
	int first = s.find_first_not_of( " \t\n\r" );
	if( first < 0 ) {
		s = "";
		return;
	}
	int last = s.find_last_not_of( " \t\n\r" );
	s = s.substr( first, (last-first+1) );
}

/*
bool CStringHelper::isFloat( const std::string& s )
{
	//[whitespace] [sign] [digits] [.digits] [ {d | D | e | E }[sign]digits]

	bool t = false;
	
	int i = 0;
	while( i < s.size() && ( s[i] == ' ' || s[i] == '\t' ) ) i++;
	if( i >= s.size() ) return t;

	if( ( s[i] == '+' ) || ( s[i] == '-' ) ) {
		i++;
		if( i >= s.size() ) return t;
	}

	if( isDigit( s[i] ) ) {
		t = true;
		while( i < s.size() && isDigit( s[i] ) ) i++;
		if( i >= s.size() ) return t;
	}

	if( s[i] == '.' ) {
		i++;
		if( i >= s.size() ) return t;

		if( isDigit( s[i] ) ) {
			t = true;
			while( i < s.size() && isDigit( s[i] ) ) i++;
			if( i >= s.size() ) return t;
		}
	}

	if( ( s[i] == 'd' ) || ( s[i] == 'D' ) || ( s[i] == 'e' ) || ( s[i] == 'E' ) ) {
		i++;
		if( i >= s.size() ) return t;

		if( ( s[i] == '+' ) || ( s[i] == '-' ) ) {
			i++;
			if( i >= s.size() ) return t;
		}

		while( i < s.size() && isDigit( s[i] ) ) i++;
		if( i >= s.size() ) return t;
	}
	return t;
}

bool CStringHelper::isInt( const std::string& s )
{
	//[whitespace] [sign] [digits] 

	bool t = false;
	
	int i = 0;
	while( i < s.size() && ( s[i] == ' ' || s[i] == '\t' ) ) i++;
	if( i >= s.size() ) return t;

	if( ( s[i] == '+' ) || ( s[i] == '-' ) ) {
		i++;
		if( i >= s.size() ) return t;
	}

	if( isDigit( s[i] ) ) {
		t = true;
		while( i < s.size() && isDigit( s[i] ) ) i++;
		if( i >= s.size() ) return t;
	}

	return t;
}
*/

bool CStringHelper::isName( const std::string& name ) 
{
	if( name.empty() )
		return false;
	if( !isLetter( name[0] ) && name[0]!='_' ) return false;
	int n = name.size();
	for( int i = 1; i < n; ++i )
		if( !( isLetter( name[i] ) || isDigit( name[i] ) || ( name[i] == '_' ) ) )
			return false;
	return true;
}

bool CStringHelper::equalsIgnoreCase( const std::string& s0, const std::string& s1 ) 
{
	if( s0.size() != s1.size() ) return false;
	std::string ss0 = s0;
	std::string ss1 = s1;
	toLower( ss0 );
	toLower( ss1 );
	return (ss0 == ss1);
}

void CStringHelper::toLower( std::string& s )
{
	int n = s.size();
	for( int i = 0; i < n; ++i )
		s[i] = tolower(s[i]);
}

std::string CStringHelper::floatValue( float f )
{
	char buffer[256];
	sprintf( buffer, "%f", f );
	return std::string( buffer );
}

std::string CStringHelper::intValue( int i )
{
	char buffer[256];
	sprintf( buffer, "%d", i );
	return std::string( buffer );
}

void CStringHelper::stripPrefix( std::string& s, const std::string& prefix )
{
	if( startsWith(s,prefix) ) {
		s = s.substr( prefix.size(), s.size()-prefix.size() );
	}
}

