// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __UNKNOWN_PTR_H
#define __UNKNOWN_PTR_H

namespace dingus {

/**
 *  Smart pointer class for COM objects.
 *
 *  Automatically AddRef's and Release's objects upon construction/desctruction of the
 *  pointer.
 *
 *  @param T Object type.
 */
template<class T>
class CUnknownPtr {
public:
	CUnknownPtr() : mPointer( 0 ) { }
	CUnknownPtr( T* ptr ) : mPointer(ptr) { }
	CUnknownPtr( const CUnknownPtr& p ) : mPointer(p.mPointer) { if( mPointer ) mPointer->AddRef(); };
	~CUnknownPtr() { if( mPointer ) mPointer->Release(); };
	
	/** @returns The object pointing to. Does not AddRef. */
	T* value() const { return mPointer; }
	/** @returns The object pointing to. Does not AddRef. */
	T* operator->() const { return mPointer; }
	/**
	 *  @returns The address of the pointer to the object - intended for COM
	 *  functions that fill the pointer. Releases the old pointer.
	 */
	T** operator&() {
		if( mPointer ) {
			mPointer->Release();
			mPointer = 0;
		}
		return &mPointer;
	}
	/** Assigns from raw pointer. Releases the old. Does not AddRef the new one. */
	void operator=( T* pointer ) {
		if( mPointer )
			mPointer->Release();
		mPointer = pointer;
	};
	bool isValid() const { return mPointer != 0; }
	bool operator!() const { return !isValid(); }
	operator bool() const { return isValid(); }

protected:
	T* mPointer;
};

}; // namespace

#endif
