// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "VisibilityContext.h"
#include "VisibilityDB.h"

using namespace dingus;


CVisibilityContext::CVisibilityContext()
{
	// initialize reserved vis databases
	addDB( DB_SOLID, *(new CDummyVisibilityDB()) );
	addDB( DB_SHADOW_CASTER, *(new CDummyVisibilityDB()) );
	addDB( DB_SHADOW_RECEIVER, *(new CDummyVisibilityDB()) );
	
	mActiveDB = &getDB( DEFAULT_VIS_DB );

	//D3DXMatrixIdentity( &getViewerMatrix() );
}

CVisibilityContext::~CVisibilityContext()
{
	stl_utils::wipe_map( mDBMap );
}

void CVisibilityContext::addDB( TVisDBID dbID, CAbstractVisibilityDB& db )
{
	mDBMap.insert( std::make_pair( dbID, &db ) );
}

CAbstractVisibilityDB& CVisibilityContext::getDB( TVisDBID dbID ) const
{
	TDatabaseMap::const_iterator db = mDBMap.find( dbID );
	
	if( db == mDBMap.end() ) {
		// TBD: throw exception here, or create defaut db
		assert( !"Visibility DB not found" );
	}
	
	assert( db->second );
	return *db->second;
}
