// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __VISIBILITY_CONTEXT_H
#define __VISIBILITY_CONTEXT_H

namespace dingus {


class CAbstractVisibilityDB;


class CVisibilityContext {
public:
	typedef int TVisDBID;
	enum {
		DB_SOLID = 0,
		DB_SHADOW_CASTER,
		DB_SHADOW_RECEIVER,
		RESERVED_DB_COUNT,
		DEFAULT_VIS_DB = DB_SOLID	// default DB
	};
		
public:
	CVisibilityContext();
	~CVisibilityContext();

	void addDB( TVisDBID dbID, CAbstractVisibilityDB& db );

	/**
	 *  Sets active visibility database.
	 *  CVisibilityStage will process this database.
	 */
	void setActiveDB( TVisDBID dbID = DEFAULT_VIS_DB ) { mActiveDB = &getDB(dbID); }
	
	CAbstractVisibilityDB& getActiveDB() const { assert(mActiveDB); return *mActiveDB; }
	
	// TBD: should be refined
	//D3DXMATRIX const& getViewerMatrix() const { return mViewerMatrix; }
	//D3DXMATRIX& getViewerMatrix() { return mViewerMatrix; }

	// TBD: should be refined
	CAbstractVisibilityDB& getDB( TVisDBID dbID = DEFAULT_VIS_DB ) const;

private:
	typedef std::map<TVisDBID, CAbstractVisibilityDB*> TDatabaseMap;
private:
	TDatabaseMap			mDBMap;
	CAbstractVisibilityDB*	mActiveDB;
	//D3DXMATRIX			mViewerMatrix;
};

}; // namespace

#endif
