// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "VisibilityDB.h"
#include "VisibilityLeaf.h"

using namespace dingus;


// --------------------------------------------------------------------------
//  CAbstractVisibilityDB


void CAbstractVisibilityDB::process( CVisibilityContext& ctx )
{
	mCurrentFrame.increase();
	processContent( ctx );
}


// --------------------------------------------------------------------------
//  CDummyVisibilityDB


void CDummyVisibilityDB::processContent( CVisibilityContext& ctx )
{
	TSlotVector::iterator it, itEnd = getLeafs().end();
	for( it = getLeafs().begin(); it != itEnd; ++it ) {
		assert( *it );
		(*it)->setVisible( *this, mMakeAllVisible );
	}
}


/*
CAbstractFrustumVisibilityDB::CAbstractFrustumVisibilityDB( bool makeVisible )
//:	mFrustum( COMMON_FRUSTUM_PLANES ),
:	mMakeVisible( makeVisible )
{
}

void CAbstractFrustumVisibilityDB::clearFrustumPlanes()
{
	mFrustum.clear();
}

void CAbstractFrustumVisibilityDB::addFrustumPlane( D3DXPLANE const& frustumPlane )
{
	mFrustum.push_back( frustumPlane );
}

void CAbstractFrustumVisibilityDB::processContent( CVisibilityContext& ctx )
{
	TFrustum cameraFrustum( mFrustum );
//	D3DXPLANE cameraFrustum[FRUSTUM_PLANES];

	// inverse and transpose viewer matrix before applying to frustum planes
	// see DirectX8.1 D3DXPlaneTransform() method documentation for more details
	D3DXMATRIX invTranViewerMatrix = ctx.getViewerMatrix();
	D3DXMatrixInverse( &invTranViewerMatrix, NULL, &invTranViewerMatrix );
	D3DXMatrixTranspose( &invTranViewerMatrix, &invTranViewerMatrix );

//	for( int q = 0; q < FRUSTUM_PLANES; q++ )
	TFrustum::const_iterator s = mFrustum.begin();
	TFrustum::iterator d = cameraFrustum.begin();
	for( ;s != mFrustum.end(); ++s, ++d )
		D3DXPlaneTransform( &(*d), &(*s), &invTranViewerMatrix );

	for( IIterator<CVisibilityLeaf*>& i = getLeafs(); i; ++i )
	{
		assert( *i );

		bool visible = mMakeVisible;
//		for( int q = 0; q < FRUSTUM_PLANES; q++ )
		for( TFrustum::const_iterator p = cameraFrustum.begin();
			p != cameraFrustum.end(); ++p )
		{
			if( !(*i)->test( *p ) )
			{
				visible = !mMakeVisible;
				break;
			}
		}

		(*i)->setVisible( *this, visible );
	}
}

COrthoFrustumVisibilityDB::COrthoFrustumVisibilityDB( bool makeVisible )
:	CAbstractFrustumVisibilityDB( makeVisible )
{
	setFrustum( 1.0f, 1.0f, 0.0f );
}

void COrthoFrustumVisibilityDB::setFrustum( float w, float h, float znear )
{
	clearFrustumPlanes();

	float halfW = w / 2.0f;
	float halfH = h / 2.0f;

	D3DXPLANE frustumPlane;

	D3DXPlaneFromPointNormal( &frustumPlane,
		&D3DXVECTOR3( -halfW, 0, 0 ), &D3DXVECTOR3( 1.0f, 0, 0 ) );
	D3DXPlaneNormalize( &frustumPlane, &frustumPlane );
	addFrustumPlane( frustumPlane );

	D3DXPlaneFromPointNormal( &frustumPlane,
		&D3DXVECTOR3( halfW, 0, 0 ), &D3DXVECTOR3( -1.0f, 0, 0 ) );
	D3DXPlaneNormalize( &frustumPlane, &frustumPlane );
	addFrustumPlane( frustumPlane );


	D3DXPlaneFromPointNormal( &frustumPlane,
		&D3DXVECTOR3( 0, -halfH, 0 ), &D3DXVECTOR3( 0, 1.0f, 0 ) );
	D3DXPlaneNormalize( &frustumPlane, &frustumPlane );
	addFrustumPlane( frustumPlane );
	
	D3DXPlaneFromPointNormal( &frustumPlane,
		&D3DXVECTOR3( 0, halfH, 0 ), &D3DXVECTOR3( 0, -1.0f, 0 ) );
	D3DXPlaneNormalize( &frustumPlane, &frustumPlane );
	addFrustumPlane( frustumPlane );


	D3DXPlaneFromPointNormal( &frustumPlane,
		&D3DXVECTOR3( 0, 0, znear ), &D3DXVECTOR3( 0, 0, 1.0f ) );	
	D3DXPlaneNormalize( &frustumPlane, &frustumPlane );
	addFrustumPlane( frustumPlane );
}


CPerspectiveFrustumVisibilityDB::CPerspectiveFrustumVisibilityDB( bool makeVisible )
:	CAbstractFrustumVisibilityDB( makeVisible )
{
}

void CPerspectiveFrustumVisibilityDB::setFrustum( D3DXMATRIX const& projectionMatrix )
{
	// NOTE: taken from DirectX8.1 'Cull' sample source
	// cull.cpp, UpdateCullInfo() method

	D3DXVECTOR3 v[8];
	v[0] = D3DXVECTOR3(-1.0f, -1.0f,  0.0f); // xyz
	v[1] = D3DXVECTOR3( 1.0f, -1.0f,  0.0f); // Xyz
	v[2] = D3DXVECTOR3(-1.0f,  1.0f,  0.0f); // xYz
	v[3] = D3DXVECTOR3( 1.0f,  1.0f,  0.0f); // XYz
	v[4] = D3DXVECTOR3(-1.0f, -1.0f,  1.0f); // xyZ
	v[5] = D3DXVECTOR3( 1.0f, -1.0f,  1.0f); // XyZ
	v[6] = D3DXVECTOR3(-1.0f,  1.0f,  1.0f); // xYZ
	v[7] = D3DXVECTOR3( 1.0f,  1.0f,  1.0f); // XYZ

	D3DXMATRIX m;
//	m = projectionMatrix;
	D3DXMatrixInverse( &m, NULL, &projectionMatrix );

    for( int i = 0; i < 8; i++ )
        D3DXVec3TransformCoord( &v[i], &v[i], &m );

	D3DXPLANE frustumPlane;

    D3DXPlaneFromPoints( &frustumPlane, &v[2], &v[6], &v[4] ); // Left
	addFrustumPlane( frustumPlane );
    D3DXPlaneFromPoints( &frustumPlane, &v[7], &v[3], &v[5] ); // Right
	addFrustumPlane( frustumPlane );

    D3DXPlaneFromPoints( &frustumPlane, &v[2], &v[3], &v[6] ); // Top
	addFrustumPlane( frustumPlane );
    D3DXPlaneFromPoints( &frustumPlane, &v[1], &v[0], &v[4] ); // Bottom
	addFrustumPlane( frustumPlane );

    D3DXPlaneFromPoints( &frustumPlane, &v[0], &v[1], &v[2] ); // Near
	addFrustumPlane( frustumPlane );
}

  */
