// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __VISIBILITY_DB_H
#define __VISIBILITY_DB_H

#include "../kernel/FrameNumber.h"

namespace dingus {



class CVisibilityContext;
class CVisibilityLeaf;

/**
 *  Abstract visibility database.
 *
 *  Visibility slots are laid out flat - no spatial hierarchies are used for now.
 */
class CAbstractVisibilityDB {
public:
	CAbstractVisibilityDB() { };
	virtual ~CAbstractVisibilityDB() { };

	void process( CVisibilityContext& ctx );

	void addLeaf( CVisibilityLeaf& slot ) { mLeafs.push_back(&slot); }
	void removeLeaf( CVisibilityLeaf& slot ) { mLeafs.remove(&slot); }

	CFrameNumber const& getCurrentFrame() const { return mCurrentFrame; };
	CFrameNumber& getCurrentFrame() { return mCurrentFrame; };
	
protected:
	typedef fastvector<CVisibilityLeaf*>	TSlotVector;

protected:
	virtual void processContent( CVisibilityContext& ctx ) = 0;

	TSlotVector const& getLeafs() const { return mLeafs; }
	TSlotVector& getLeafs() { return mLeafs; }
	
private:
	TSlotVector		mLeafs;
	CFrameNumber	mCurrentFrame;
};


class CDummyVisibilityDB : public CAbstractVisibilityDB {
public:
	CDummyVisibilityDB( bool makeAllVisible = true )
		: mMakeAllVisible( makeAllVisible ) {}
	
protected:
	virtual void processContent( CVisibilityContext& ctx );
	
private:
	bool	mMakeAllVisible;
};


/*
class CAbstractFrustumVisibilityDB : public CAbstractVisibilityDB
{
	enum { COMMON_FRUSTUM_PLANES = 5 };
	typedef std::vector<D3DXPLANE>	TFrustum;

public:
	CAbstractFrustumVisibilityDB( bool makeVisible = true );
	virtual ~CAbstractFrustumVisibilityDB() = 0 {};

protected:
	void clearFrustumPlanes();
	void addFrustumPlane( D3DXPLANE const& frustumPlane );

	// CAbstractVisibilityDB
	virtual void processContent( CVisibilityContext& ctx );

private:
	TFrustum	mFrustum;
	bool		mMakeVisible;
};

class COrthoFrustumVisibilityDB : public CAbstractFrustumVisibilityDB
{
public:
	COrthoFrustumVisibilityDB ( bool makeVisible = true );

	void setFrustum( float w, float h, float znear );
};

class CPerspectiveFrustumVisibilityDB : public CAbstractFrustumVisibilityDB
{
public:
	CPerspectiveFrustumVisibilityDB( bool makeVisible = true );

	void setFrustum( D3DXMATRIX const& projectionMatrix );
};
*/


}; // namespace

#endif