// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "VisibilityLeaf.h"

using namespace dingus;

// --------------------------------------------------------------------------


void CVisibilityLeaf::setVisible( CAbstractVisibilityDB const& db, bool visible )
{
	mVisibleOnFrame = db.getCurrentFrame();
	if( visible ) {
		// notify listeners
		mListeners.onVisible( *this );
	} else {
		// make invisible
		mVisibleOnFrame.increase( -1 );
	}
}

/*
bool CSphereVisibilityLeaf::test( D3DXVECTOR3 const& origin, D3DXVECTOR3 const& direction )
{
	return D3DXSphereBoundProbe( &mOrigin, mRadius, &origin, &direction ) ? true : false;
}

bool CSphereVisibilityLeaf::test( D3DXVECTOR3 const& origin, float radius )
{
	// TBD:
	return true;
}

bool CSphereVisibilityLeaf::test( D3DXPLANE const& plane )
{
	float dot = D3DXPlaneDotCoord( &plane, &mOrigin );
//    return ( dot <= -mRadius );
    return ( dot > -mRadius );
}


bool CAABBVisibilityLeaf::test( D3DXVECTOR3 const& origin, D3DXVECTOR3 const& direction )
{
	return D3DXBoxBoundProbe( &mLeft, &mRight, &origin, &direction ) ? true : false;
}

bool CAABBVisibilityLeaf::test( D3DXVECTOR3 const& origin, float radius )
{
	// TBD:
	return true;
}

bool CAABBVisibilityLeaf::test( D3DXPLANE const& plane )
{
	if( D3DXPlaneDotCoord( &plane, &mLeft ) >= 0 ) return true;
	if( D3DXPlaneDotCoord( &plane, &mRight ) >= 0 ) return true;

	D3DXVECTOR3 v1( mLeft ), v2( mRight );

	v1.x = mRight.x;
	v1.y = mLeft.y;
	v2.x = mLeft.x;
	v2.y = mRight.y;

	if( D3DXPlaneDotCoord( &plane, &v1 ) >= 0 ) return true;
	if( D3DXPlaneDotCoord( &plane, &v2 ) >= 0 ) return true;

	v1.x = mLeft.x;
	v1.y = mRight.y;
	v2.x = mRight.x;
	v2.y = mLeft.y;

	if( D3DXPlaneDotCoord( &plane, &v1 ) >= 0 ) return true;
	if( D3DXPlaneDotCoord( &plane, &v2 ) >= 0 ) return true;

	v1.x = mRight.x;
	v1.y = mRight.y;
	v2.x = mLeft.x;
	v2.y = mLeft.y;

	if( D3DXPlaneDotCoord( &plane, &v1 ) >= 0 ) return true;
	if( D3DXPlaneDotCoord( &plane, &v2 ) >= 0 ) return true;

	return false;
}


bool COBBVisibilityLeaf::test( D3DXVECTOR3 const& origin, D3DXVECTOR3 const& direction )
{
	// TBD:
	return true;
}

bool COBBVisibilityLeaf::test( D3DXVECTOR3 const& origin, float radius )
{
	// TBD:
	return true;
}

bool COBBVisibilityLeaf::test( D3DXPLANE const& plane )
{
#if 0
   Real fTmp[3] =
    {
        rkBox.Extent(0)*(rkPlane.Normal().Dot(rkBox.Axis(0))),
        rkBox.Extent(1)*(rkPlane.Normal().Dot(rkBox.Axis(1))),
        rkBox.Extent(2)*(rkPlane.Normal().Dot(rkBox.Axis(2)))
    };

    Real fRadius = Math::FAbs(fTmp[0]) + Math::FAbs(fTmp[1]) +
        Math::FAbs(fTmp[2]);

    Real fPseudoDistance = rkPlane.DistanceTo(rkBox.Center());
    return Math::FAbs(fPseudoDistance) <= fRadius;
#endif
	return true;

}
*/
