// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __VISIBILITY_LEAF_H
#define __VISIBILITY_LEAF_H

#include "../math/Primitives.h"
#include "../utils/AbstractNotifier.h"
#include "VisibilityDB.h"


namespace dingus {


class CVisibilityLeaf;


// --------------------------------------------------------------------------

class IVisibilityListener {
public:
	virtual ~IVisibilityListener() = 0 {};
	virtual void onVisible( CVisibilityLeaf const& visLeaf ) = 0;
};


// --------------------------------------------------------------------------

class CVisibilityLeaf {
public:
	CVisibilityLeaf() { };
	virtual ~CVisibilityLeaf() { };

	virtual bool test( SRay const& ray ) const { return true; }
	virtual bool test( SSphere const& sphere ) const { return true; }
	//virtual bool test( SPlane const& plane ) const { return true; }

	// TBD: must be refined
	void setVisible( CAbstractVisibilityDB const& db, bool visible = true );
	bool isVisible( CAbstractVisibilityDB const& db ) const { return db.getCurrentFrame() == mVisibleOnFrame; }
	
	void addListener( IVisibilityListener& listener ) { mListeners.addListener(listener); }
	void removeListener( IVisibilityListener& listener ) { mListeners.removeListener(listener); }
	
private:
	class CVisibleNotifier : public CAbstractNotifierData<IVisibilityListener, CVisibilityLeaf&> {
	public:
		void onVisible( CVisibilityLeaf& slot ) {
			notify( slot );
		}
	protected:
		virtual void notifyListener( IVisibilityListener& listener, CVisibilityLeaf& slot ) {
			listener.onVisible( slot );
		}
	};
	
private:
	CFrameNumber		mVisibleOnFrame;
	CVisibleNotifier	mListeners;
};

// --------------------------------------------------------------------------

/*
class CSphereVisibilityLeaf : public CVisibilityLeaf
{
public:
	virtual bool test( D3DXVECTOR3 const& origin, D3DXVECTOR3 const& direction );
	virtual bool test( D3DXVECTOR3 const& origin, float radius );
	virtual bool test( D3DXPLANE const& plane );

	D3DXVECTOR3	const& getOrigin() const { return mOrigin; }
	D3DXVECTOR3& getOrigin() { return mOrigin; }

	float const& getRadius() const { return mRadius; }
	float& getRadius() { return mRadius; }

private:
	D3DXVECTOR3	mOrigin;
	float		mRadius;
};

// --------------------------------------------------------------------------

class CAABBVisibilityLeaf : public CVisibilityLeaf
{
public:
	virtual bool test( D3DXVECTOR3 const& origin, D3DXVECTOR3 const& direction );
	virtual bool test( D3DXVECTOR3 const& origin, float radius );
	virtual bool test( D3DXPLANE const& plane );

	D3DXVECTOR3	const& getLeft() const { return mLeft; }
	D3DXVECTOR3& getLeft() { return mLeft; }

	D3DXVECTOR3	const& getRight() const { return mRight; }
	D3DXVECTOR3& getRight() { return mRight; }

private:
	D3DXVECTOR3	mLeft;
	D3DXVECTOR3	mRight;
};

// --------------------------------------------------------------------------

class COBBVisibilityLeaf : public CVisibilityLeaf
{
public:
	virtual bool test( D3DXVECTOR3 const& origin, D3DXVECTOR3 const& direction );
	virtual bool test( D3DXVECTOR3 const& origin, float radius );
	virtual bool test( D3DXPLANE const& plane );

	D3DXVECTOR3	const& getLeft() const { return mLeft; }
	D3DXVECTOR3& getLeft() { return mLeft; }

	D3DXVECTOR3	const& getRight() const { return mRight; }
	D3DXVECTOR3& getRight() { return mRight; }

private:
	D3DXVECTOR3	mLeft;
	D3DXVECTOR3	mRight;
};
*/

}; // namespace


#endif
