// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __VISIBILITY_STAGE_H
#define __VISIBILITY_STAGE_H

#include "../pipeline/PipelineStage.h"


namespace dingus {


class CVisibilityContext;


class CVisibilityStage : public IPipelineStage {
public:
	explicit CVisibilityStage( CVisibilityContext& ctx ) : mCtx(&ctx) { };
	virtual ~CVisibilityStage() { };

	// IPipelineStage

	/**
	 *  Processes the active vis DB in the context.
	 */
	virtual void perform();

	CVisibilityContext const& getContext() const { return *mCtx; };
	CVisibilityContext& getContext() { return *mCtx; };
	void setContext( CVisibilityContext& ctx ) { mCtx = &ctx; };
	
private:
	CVisibilityContext*	mCtx;
};


}; // namespace

#endif
