-- Exports all mesh collider info
fileName = getSaveFileName caption:"Export Colliders File" types:"Lua files (*.lua)|*.lua|All Files (*.*)|*.*|"
if fileName != undefined do (
	file = createfile fileName
	format "colliders = {\n" to:file
	deselect objects
	unfreeze objects
	select geometry
	n = selection.count
	for i = 1 to n do (
		select geometry
		mesh = selection[i]
		deselect geometry
		select mesh
		if mesh.parent == undefined do in coordsys world (
			format "{ name='%', cols={\n" mesh.name to:file
			for c in mesh.children do in coordsys parent (
				if iskindof c Box do (
					format "\t{ clazz='box', size={%,%,%},\n" c.width c.height c.length to:file
					format "\t  pos={%,%,%},\n" c.pos.x c.pos.z c.pos.y to:file
					format "\t  rot={%,%,%,%} },\n" c.rotation.x c.rotation.z c.rotation.y c.rotation.w to:file
				)
				if iskindof c Sphere do (
					format "\t{ clazz='sphere', radius=%,\n" c.radius to:file
					format "\t  pos={%,%,%},\n" c.pos.x c.pos.z c.pos.y to:file
					format "\t  rot={%,%,%,%} },\n" c.rotation.x c.rotation.z c.rotation.y c.rotation.w to:file
				)
				if iskindof c Editable_Mesh do (
					format "\t{ clazz='mesh', name='%',\n" c.name to:file
					format "\t  pos={%,%,%},\n" c.pos.x c.pos.z c.pos.y to:file
					format "\t  rot={%,%,%,%} },\n" c.rotation.x c.rotation.z c.rotation.y c.rotation.w to:file
				)
			)
			format "} },\n" to:file
		)
	)
	format "}\n" to:file
	close file
)
