-- Exports all meshes to .x files
-- Before exporting, puts object into identity transform for exporting in world
-- space as in local space; then puts it back.
dirName = getSavePath caption:"Export to"
if dirName != undefined do (
	deselect objects
	unfreeze objects
	i = 0
	for mesh in geometry do in coordsys parent (
		if iskindof mesh Editable_Mesh do (
			deselect geometry
			select mesh
			fileName = dirName + "\\" + mesh.name + ".x"
			oldPos = mesh.position
			oldRot = mesh.rotation
			in coordsys world (
				mesh.position = [0,0,0]
				mesh.rotation = quat 0 0 0 1
			)
			if i == 0 then
				exportFile fileName selectedOnly:true
			else
				exportFile fileName #noPrompt selectedOnly:true
			mesh.position = oldPos
			mesh.rotation = oldRot
			i = i+1
		)
	)
)
