-- Exports all tag_* named objects to a file as Lua source
-- Builds a table "tags" as sequential array, where each element
-- has members: "name", the name of the object; "tag", the name of the tag;
-- "pos", array of 3 numbers, and "rot", array of 4 numbers.
-- Data is converted to D3D-style frame (y and z are swapped).
deselect objects
unfreeze objects
select $tag_*
if selection.count > 0 do (
	fileName = getSaveFileName caption:"Export Tags File" types:"Lua files (*.lua)|*.lua|All Files (*.*)|*.*|"
	if fileName != undefined do (
		file = createfile fileName
		format "tags = {\n" to:file
		for tag in selection do (
			if iskindof tag node do in coordsys parent (
				format "{\n" to:file
				format "\tname='%', tag='%',\n" tag.parent.name tag.name to:file
				format "\tpos={%,%,%},\n" tag.pos.x tag.pos.z tag.pos.y to:file
				format "\trot={%,%,%,%}\n" tag.rotation.x tag.rotation.z tag.rotation.y tag.rotation.w to:file
				format "},\n" to:file
			)
		)
		format "}\n" to:file
		close file
	)
)
